/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.util.functions;

import dev.toma.gunsrpg.resource.util.functions.ComparatorFunction;
import dev.toma.gunsrpg.resource.util.functions.ConstantFunction;
import dev.toma.gunsrpg.resource.util.functions.IFunction;
import dev.toma.gunsrpg.resource.util.functions.IFunctionAdapter;
import dev.toma.gunsrpg.resource.util.functions.ListFunction;
import dev.toma.gunsrpg.resource.util.functions.RangedFunction;
import java.util.HashMap;
import java.util.Map;

public final class Functions {
    private static final Functions REGISTRY = new Functions();
    private final Map<String, IFunctionAdapter<?>> functionAdapterMap = new HashMap();

    public static Functions getRegistry() {
        return REGISTRY;
    }

    public void register(String function, IFunctionAdapter<?> adapter) {
        this.functionAdapterMap.put(function, adapter);
    }

    public <F extends IFunction> IFunctionAdapter<F> getAdapter(String function) {
        return this.functionAdapterMap.get(function);
    }

    private Functions() {
        this.register("false", new ConstantFunction.Adapter(false));
        this.register("true", new ConstantFunction.Adapter(true));
        this.register("each", new ComparatorFunction.Adapter(ComparatorFunction.EACH));
        this.register("equal", new ComparatorFunction.Adapter(ComparatorFunction.EQUAL));
        this.register("smaller", new ComparatorFunction.Adapter(ComparatorFunction.SMALLER));
        this.register("smallerOrEqual", new ComparatorFunction.Adapter(ComparatorFunction.SMALLER_EQUAL));
        this.register("bigger", new ComparatorFunction.Adapter(ComparatorFunction.BIGGER));
        this.register("biggerOrEqual", new ComparatorFunction.Adapter(ComparatorFunction.BIGGER_EQUAL));
        this.register("betweenInclusive", new RangedFunction.Adapter(RangedFunction.BETWEEN_INCLUSIVE));
        this.register("betweenExclusive", new RangedFunction.Adapter(RangedFunction.BETWEEN_EXCLUSIVE));
        this.register("oneOf", new ListFunction.Adapter());
    }
}

